Scriptname _SLSubmitConfig extends ski_configbase  

_SLSubmitQuest Property _SLQuest Auto
_SLSubmitFunctions Property _SLFunctions Auto
GlobalVariable Property _SLSubmitDisableRapeGlobal  Auto
GlobalVariable Property _SLSubmitDisableSpeechGlobal  Auto
GlobalVariable Property _SLSubmitFollowerMorality  Auto 
GlobalVariable Property _SLSubmitGenderMaleGlobal  Auto 
GlobalVariable Property _SLSubmitGenderFemaleGlobal  Auto 
Spell Property _SLSubmitAutoSurrender  Auto
Spell Property _SLSubmitAutoSurrenderHit Auto
MagicEffect Property _SLAutoSurrender  Auto
MagicEffect Property _SLAutoSurrenderHit Auto
Actor Property PlayerRef Auto

int keyMapOptionID = 0
int keySurrenderOptionID = 0
int enableModOptionID = 0
int enableDebugOptionID = 0
int enableDisarmOptionID = 0
int enableGrappleOptionID = 0
int enableSpeechOptionID = 0
int enableRobOptionID = 0
int enableRapeOptionID = 0
int enableBondageOptionID = 0
int enableSurrenderOptionID = 0
int enableVictimOptionID = 0
int enableFollowerOptionID = 0
int enableStealOptionID = 0
int enableSellOptionID = 0
int enableGuardOptionID = 0
int enableHardcoreOptionID = 0
int enableRepeatOptionID = 0
int enableNoDeathOptionID = 0
int enableVampireOptionID = 0
int enableAutoSurrenderOptionID = 0
int enableAmbushSexOptionID = 0
int enableDebuffsOptionID = 0
int enableLeveledProgOptionID = 0
int enablePunishmentOptionID = 0
int enableAttackOptionID = 0
int enableLoggingOptionID = 0

int property currentKeyCode	auto	;NP7
bool property modActive auto
bool property debugActive auto
bool property DisarmActive auto
bool property GrappleActive auto
bool property SpeechActive auto
bool property RobActive auto
bool property RapeActive auto
bool property BondageActive auto
bool property SurrenderActive auto
bool property VictimActive auto
bool property FollowerActive auto
bool property StealActive auto
bool property SellStolen auto
bool property GuardActive auto
bool property HardcoreActive auto
bool property RepeatActive auto
bool property NoDeathActive auto
bool property VampireActive auto
bool property AutoSurrenderActive auto
bool property AmbushSexActive auto
bool property DebuffsActive auto
bool property LeveledProgActive auto
bool property PunishmentActive auto
bool property AttackActive auto
bool property LoggingActive auto
float property ShoutCooldown auto
float property CDifficulty auto
float property SDifficulty auto
float property Morality auto
float property Bribery auto
float property Escape auto
float property Creature auto
float property Gender auto
float property RepeatRate auto
float property Range auto
float property AutoSubmitPercent auto
float property AutoSubmit auto
float property AutoSubmitChancePercent auto
float property AutoSubmitChance auto
int oidCooldown
int oidCDifficulty
int oidSDifficulty
int oidMorality
int oidBribery
int oidEscape
int oidCreature
int oidGender
int oidRepeatRate
int oidRange
int oidAutoSubmit
int oidAutoSubmitChance

;============================
; Events
;============================
Event OnConfigInit()
	SetupPages()
EndEvent

Event OnPageReset(String page)
	if (page == "")
		LoadCustomContent("SexLabSubmit/SexLab_Submit.dds", 104, 32)
		return
	else
		UnloadCustomContent()
	EndIf
	If page == "General"
		SetCursorFillMode(TOP_TO_BOTTOM)
		AddHeaderOption("$_SLSubmit_General")
		keyMapOptionID = AddKeymapOption("$_SLSubmit_SubmitKey", currentKeyCode, EnableOption(modActive))
		enableModOptionID = AddToggleOption("$_SLSubmit_ModActive", modActive)
		enableDebugOptionID = AddToggleOption("$_SLSubmit_DebugNotificationActive", debugActive, EnableOption(modActive))
		enableRapeOptionID = AddToggleOption("$_SLSubmit_RapeContentActive", RapeActive, EnableOption(modActive))
		enableBondageOptionID = AddToggleOption("$_SLSubmit_BondageActive", BondageActive, EnableOption(modActive))
		oidCDifficulty = AddSliderOption("$_SLSubmit_CDifficultyAdjust", CDifficulty, "$_SLSubmit_+{0}%CSuccessChance", EnableOption(modActive))
		oidMorality = AddSliderOption("$_SLSubmit_FollowerMorality", Morality, "$_SLSubmit_{0}Morality", EnableOption(modActive))
		AddEmptyOption()
		AddHeaderOption("$_SLSubmit_Sex")
		enableSpeechOptionID = AddToggleOption("$_SLSubmit_SpeechDialogActive", SpeechActive, EnableOption(modActive))
		oidBribery = AddSliderOption("$_SLSubmit_BriberyMultiple", Bribery, "$_SLSubmit_{0}Bribery", EnableOption(modActive && SpeechActive))
		oidSDifficulty = AddSliderOption("$_SLSubmit_SDifficultyAdjust", SDifficulty, "$_SLSubmit_+{0}%SSuccessChance", EnableOption(modActive && SpeechActive))
		oidGender = AddSliderOption("$_SLSubmit_GenderLevel", Gender, "$_SLSubmit_{0}Gender", EnableOption(modActive && SpeechActive))
		enableGuardOptionID = AddToggleOption("$_SLSubmit_GuardActive", GuardActive, EnableOption(modActive && SpeechActive))
		AddEmptyOption()
		AddHeaderOption("$_SLSubmit_DD")
		enableDebuffsOptionID = AddToggleOption("$_SLSubmit_DebuffsActive", DebuffsActive, EnableOption(False)) ; DISABLED
		enableLeveledProgOptionID = AddToggleOption("$_SLSubmit_LeveledProgActive", LeveledProgActive, EnableOption(modActive))
		AddEmptyOption()
		AddHeaderOption("$_SLSubmit_Debug")
		enableLoggingOptionID = AddToggleOption("$_SLSubmit_LoggingActive", LoggingActive, EnableOption(modActive))
	ElseIf page == "Player as Victor"
		SetCursorFillMode(TOP_TO_BOTTOM)
		AddHeaderOption("$_SLSubmit_General")
		enableAttackOptionID = AddToggleOption("$_SLSubmit_AttackActive", AttackActive, EnableOption(modActive))
		oidCooldown = AddSliderOption("$_SLSubmit_SubmitCooldown", ShoutCooldown, "$_SLSubmit_{0}Seconds", EnableOption(modActive && AttackActive))
		enableGrappleOptionID = AddToggleOption("$_SLSubmit_SubmitGrappleActive", GrappleActive, EnableOption(modActive && AttackActive))
		enableAmbushSexOptionID = AddToggleOption("$_SLSubmit_AmbushSexActive", AmbushSexActive, EnableOption(modActive && AttackActive))
		;enableDisarmOptionID = AddToggleOption("$_SLSubmit_ShoutDisarmActive", DisarmActive)
		enableRobOptionID = AddToggleOption("$_SLSubmit_AutomaticLootActive", RobActive, EnableOption(modActive && AttackActive))
		enableVictimOptionID = AddToggleOption("$_SLSubmit_FemalePlayer/FollowerInVictimRole", VictimActive, EnableOption(modActive && AttackActive))
		enableVampireOptionID = AddToggleOption("$_SLSubmit_VampireActive", VampireActive, EnableOption(modActive && AttackActive))
	ElseIf page == "Player as Victim"
		SetCursorFillMode(TOP_TO_BOTTOM)
		AddHeaderOption("$_SLSubmit_General")
		enableSurrenderOptionID = AddToggleOption("$_SLSubmit_PlayerSubmitActive", SurrenderActive, EnableOption(modActive))
		oidRange = AddSliderOption("$_SLSubmit_RangeLevel", Range, "$_SLSubmit_{0}Range", EnableOption(modActive && SurrenderActive))
		enableStealOptionID = AddToggleOption("$_SLSubmit_StealGearActive", StealActive, EnableOption(modActive && SurrenderActive))
		enableSellOptionID = AddToggleOption("$_SLSubmit_SellStolen", SellStolen, EnableOption(modActive && SurrenderActive && StealActive))
		oidCreature = AddSliderOption("$_SLSubmit_CreatureLevel", Creature, "$_SLSubmit_{0}Creature", EnableOption(modActive && SurrenderActive))
		AddEmptyOption()
		AddHeaderOption("$_SLSubmit_Escape")
		oidEscape = AddSliderOption("$_SLSubmit_EscapeLevel", Escape, "$_SLSubmit_{0}Escape", EnableOption(modActive && SurrenderActive))
		enablePunishmentOptionID = AddToggleOption("$_SLSubmit_PunishmentActive", PunishmentActive, EnableOption(modActive && SurrenderActive))
		enableRepeatOptionID = AddToggleOption("$_SLSubmit_RepeatActive", RepeatActive, EnableOption(modActive && SurrenderActive))
		oidRepeatRate = AddSliderOption("$_SLSubmit_RepeatRateLevel", RepeatRate, "$_SLSubmit_{0}RepeatRate", EnableOption(modActive && SurrenderActive))
		enableHardcoreOptionID = AddToggleOption("$_SLSubmit_HardcoreActive", HardcoreActive, EnableOption(modActive && SurrenderActive && !_SLQuest.DeathAlternative))
		AddEmptyOption()
		AddHeaderOption("$_SLSubmit_AS")
		enableAutoSurrenderOptionID = AddToggleOption("$_SLSubmit_AutoSubmitActive", AutoSurrenderActive, EnableOption(modActive && SurrenderActive && !_SLQuest.DeathAlternative))
		oidAutoSubmit = AddSliderOption("$_SLSubmit_AutoSubmit", AutoSubmitPercent, "$_SLSubmit_{0}AutoSubmit", EnableOption(modActive && SurrenderActive && AutoSurrenderActive))
		oidAutoSubmitChance = AddSliderOption("$_SLSubmit_AutoSubmitChance", AutoSubmitChancePercent, "$_SLSubmit_{0}AutoSubmitChance", EnableOption(modActive && SurrenderActive && AutoSurrenderActive))
		enableNoDeathOptionID = AddToggleOption("$_SLSubmit_NoDeathActive", NoDeathActive, EnableOption(modActive && SurrenderActive && AutoSurrenderActive))
		AddEmptyOption()
		AddHeaderOption("$_SLSubmit_Follower")
		enableFollowerOptionID = AddToggleOption("$_SLSubmit_FollowerActive", FollowerActive, EnableOption(modActive && SurrenderActive))
	ElseIf page == "Information"
		SetCursorFillMode(TOP_TO_BOTTOM)
		AddTextOption("Version", GetVersion())
		AddTextOption("Dawnguard", _SLQuest.Dawnguard)
		AddTextOption("Dragonborn", _SLQuest.Dragonborn)
		AddTextOption("Death Alternative", _SLQuest.DeathAlternative)
		AddTextOption("Prison Overhaul", _SLQuest.PrisonOverhaul)
	EndIf
	;AddEmptyOption()
EndEvent

Event OnOptionKeyMapChange(int option, int keyCode, String conflictControl, String conflictName)
	If(option == keyMapOptionID)
		currentKeyCode = keyCode
		SetKeyMapOptionValue(keyMapOptionID, currentKeyCode)
		_SLQuest.SetSubmitKeyCode(currentKeyCode)
	EndIf
EndEvent

Event OnVersionUpdate(int newVersion)
	if newVersion != CurrentVersion
		;ModName = "SexLab Submit v" + newVersion/100 + "." + newVersion%100
		SetupPages()
	EndIf
EndEvent

Event OnOptionDefault(int option)
	If(option == keyMapOptionID)
		currentKeyCode = 71	;NP7
		SetKeyMapOptionValue(keyMapOptionID, currentKeyCode)
		_SLQuest.setSubmitKeyCode(currentKeyCode)
	ElseIf(option == enableModOptionID)
		If(!modActive)
			modActive = true
			SetToggleOptionValue(enableModOptionID, modActive)
			ActivateMod(modActive)
		EndIf
	ElseIf(option == enableDebugOptionID)
		If(!debugActive)
			debugActive = true
			SetToggleOptionValue(enableDebugOptionID, debugActive)
		EndIf
	ElseIf(option == enableDisarmOptionID)
		If(!DisarmActive)
			DisarmActive = true
			SetToggleOptionValue(enableDisarmOptionID, DisarmActive)
		EndIf
	ElseIf(option == enableAttackOptionID)
		If(!AttackActive)
			AttackActive = true
			SetToggleOptionValue(enableAttackOptionID, AttackActive)
			ActivateAttack(modActive && AttackActive)
		EndIf
	ElseIf(option == enableGrappleOptionID)
		If(!GrappleActive)
			GrappleActive = false
			SetToggleOptionValue(enableGrappleOptionID, GrappleActive)
		EndIf
	ElseIf(option == enableSpeechOptionID)
		If(!SpeechActive)
			SpeechActive = true
			SetToggleOptionValue(enableSpeechOptionID, SpeechActive)
			ActivateSpeech(modActive && SpeechActive)
		EndIf
	ElseIf(option == enableRobOptionID)
		If(!RobActive)
			RobActive = true
			SetToggleOptionValue(enableRobOptionID, RobActive)
		EndIf
	ElseIf(option == enableRapeOptionID)
		If(!RapeActive)
			RapeActive = true
			SetToggleOptionValue(enableRapeOptionID, RapeActive)
			ActivateRape(modActive && RapeActive)
		EndIf
	ElseIf(option == enableBondageOptionID)
		If(!BondageActive)
			BondageActive = true
			SetToggleOptionValue(enableBondageOptionID, BondageActive)
		EndIf
	ElseIf(option == enableSurrenderOptionID)
		If(!SurrenderActive)
			SurrenderActive = true
			SetToggleOptionValue(enableSurrenderOptionID, SurrenderActive)
			ActivateSurrender(modActive && SurrenderActive)
		EndIf
	ElseIf(option == enableStealOptionID)
		If(!StealActive)
			StealActive = false
			SetToggleOptionValue(enableStealOptionID, StealActive)
			ActivateSteal(modActive && SurrenderActive && StealActive)
		EndIf
	ElseIf(option == enableSellOptionID)
		If(!SellStolen)
			SellStolen = false
			SetToggleOptionValue(enableSellOptionID, SellStolen)
		EndIf
	ElseIf(option == enableVictimOptionID)
		If(!VictimActive)
			VictimActive = false
			SetToggleOptionValue(enableVictimOptionID, VictimActive)
		EndIf
	ElseIf(option == enableGuardOptionID)
		If(!GuardActive)
			GuardActive = true
			SetToggleOptionValue(enableGuardOptionID, GuardActive)
		EndIf
	ElseIf(option == enableHardcoreOptionID)
		If(!HardcoreActive)
			HardcoreActive = false
			SetToggleOptionValue(enableHardcoreOptionID, HardcoreActive)
		EndIf
	ElseIf(option == enableRepeatOptionID)
		If(!RepeatActive)
			RepeatActive = true
			SetToggleOptionValue(enableRepeatOptionID, RepeatActive)
		EndIf
	ElseIf(option == enableNoDeathOptionID)
		If(!NoDeathActive)
			NoDeathActive = true
			SetToggleOptionValue(enableNoDeathOptionID, NoDeathActive)
			ActivateNoDeath(modActive && SurrenderActive && AutoSurrenderActive && NoDeathActive)
		EndIf
	ElseIf(option == enableVampireOptionID)
		If(!VampireActive)
			VampireActive = true
			SetToggleOptionValue(enableVampireOptionID, VampireActive)
		EndIf
	ElseIf(option == enableAmbushSexOptionID)
		If(!AmbushSexActive)
			AmbushSexActive = true
			SetToggleOptionValue(enableAmbushSexOptionID, AmbushSexActive)
		EndIf
	ElseIf(option == enableDebuffsOptionID)
		If(!DebuffsActive)
			DebuffsActive = true
			SetToggleOptionValue(enableDebuffsOptionID, DebuffsActive)
		EndIf
	ElseIf(option == enableLeveledProgOptionID)
		If(!LeveledProgActive)
			LeveledProgActive = true
			SetToggleOptionValue(enableLeveledProgOptionID, LeveledProgActive)
		EndIf
	ElseIf(option == enablePunishmentOptionID)
		If(!PunishmentActive)
			PunishmentActive = true
			SetToggleOptionValue(enablePunishmentOptionID, PunishmentActive)
		EndIf
	ElseIf(option == enableAutoSurrenderOptionID)
		If(!AutoSurrenderActive)
			AutoSurrenderActive = false
			SetToggleOptionValue(enableAutoSurrenderOptionID, AutoSurrenderActive)
			ActivateAutoSurrender(modActive && SurrenderActive && AutoSurrenderActive && !_SLQuest.DeathAlternative)
		EndIf
	ElseIf(option == enableFollowerOptionID)
		If(!FollowerActive)
			FollowerActive = false
			SetToggleOptionValue(enableFollowerOptionID, FollowerActive)
		EndIf
	ElseIf(option == enableLoggingOptionID)
		If(!LoggingActive)
			LoggingActive = True
			SetToggleOptionValue(enableLoggingOptionID, LoggingActive)
		EndIf
	EndIf
EndEvent

Event OnOptionHighlight(int option)
	If(option == keyMapOptionID)
		SetInfoText("$_SLSubmit_Hotkey")
	ElseIf(option == enableModOptionID)
		If(!modActive)
			SetInfoText("$_SLSubmit_ModOff")
		Else
			SetInfoText("$_SLSubmit_ModOn")
		EndIf
	ElseIf(option == enableDebugOptionID)
		If(!debugActive)
			SetInfoText("$_SLSubmit_DebugOff")
		Else
			SetInfoText("$_SLSubmit_DebugOn")
		EndIf
	ElseIf(option == enableAttackOptionID)
		If(!AttackActive)
			SetInfoText("$_SLSubmit_AttackOff")
		Else
			SetInfoText("$_SLSubmit_AttackOn")
		EndIf
	ElseIf(option == oidCooldown)
		SetInfoText("$_SLSubmit_Cooldown")
	ElseIf(option == oidCDifficulty)
		SetInfoText("$_SLSubmit_CDifficulty")
	ElseIf(option == oidSDifficulty)
		SetInfoText("$_SLSubmit_SDifficulty")
	ElseIf(option == oidMorality)
		SetInfoText("$_SLSubmit_Morality")
	ElseIf(option == oidAutoSubmit)
		SetInfoText("$_SLSubmit_Submit")
	ElseIf(option == oidAutoSubmitChance)
		SetInfoText("$_SLSubmit_SubmitChance")
	ElseIf(option == oidBribery)
		SetInfoText("$_SLSubmit_Bribery")
	ElseIf(option == oidEscape)
		SetInfoText("$_SLSubmit_Escape")
	ElseIf(option == oidCreature)
		SetInfoText("$_SLSubmit_Creature")
	ElseIf(option == oidGender)
		SetInfoText("$_SLSubmit_Gender")
	ElseIf(option == oidRepeatRate)
		SetInfoText("$_SLSubmit_RepeatRate")
	ElseIf(option == oidRange)
		SetInfoText("$_SLSubmit_Range")
	ElseIf(option == enableDisarmOptionID)
		If(!DisarmActive)
			SetInfoText("$_SLSubmit_DisarmOff")
		Else
			SetInfoText("$_SLSubmit_DisarmOn")
		EndIf
	ElseIf(option == enableGrappleOptionID)
		If(!GrappleActive)
			SetInfoText("$_SLSubmit_GrappleOff")
		Else
			SetInfoText("$_SLSubmit_GrappleOn")
		EndIf
	ElseIf(option == enableAmbushSexOptionID)
		If(!AmbushSexActive)
			SetInfoText("$_SLSubmit_AmbushOff")
		Else
			SetInfoText("$_SLSubmit_AmbushOn")
		EndIf
	ElseIf(option == enableDebuffsOptionID)
		If(!DebuffsActive)
			SetInfoText("$_SLSubmit_DebuffsOff")
		Else
			SetInfoText("$_SLSubmit_DebuffsOn")
		EndIf
	ElseIf(option == enableLeveledProgOptionID)
		If(!LeveledProgActive)
			SetInfoText("$_SLSubmit_LeveledProgOff")
		Else
			SetInfoText("$_SLSubmit_LeveledProgOn")
		EndIf
	ElseIf(option == enablePunishmentOptionID)
		If(!PunishmentActive)
			SetInfoText("$_SLSubmit_PunishmentOff")
		Else
			SetInfoText("$_SLSubmit_PunishmentOn")
		EndIf
	ElseIf(option == enableSpeechOptionID)
		If(!SpeechActive)
			SetInfoText("$_SLSubmit_SpeechOff")
		Else
			SetInfoText("$_SLSubmit_SpeechOn")
		EndIf
	ElseIf(option == enableRobOptionID)
		If(!RobActive)
			SetInfoText("$_SLSubmit_RobOff")
		Else
			SetInfoText("$_SLSubmit_RobOn")
		EndIf
	ElseIf(option == enableRapeOptionID)
		If(!RapeActive)
			SetInfoText("$_SLSubmit_RapeOff")
		Else
			SetInfoText("$_SLSubmit_RapeOn")
		EndIf
	ElseIf(option == enableBondageOptionID)
		If(!BondageActive)
			SetInfoText("$_SLSubmit_BondageOff")
		Else
			SetInfoText("$_SLSubmit_BondageOn")
		EndIf
	ElseIf(option == enableSurrenderOptionID)
		If(!SurrenderActive)
			SetInfoText("$_SLSubmit_PlayerOff")
		Else
			SetInfoText("$_SLSubmit_PlayerOn")
		EndIf
	ElseIf(option == enableAutoSurrenderOptionID)
		If(!AutoSurrenderActive)
			SetInfoText("$_SLSubmit_AutoOff")
		Else
			SetInfoText("$_SLSubmit_AutoOn")
		EndIf
	ElseIf(option == enableFollowerOptionID)
		If(!FollowerActive)
			SetInfoText("$_SLSubmit_FollowerOff")
		Else
			SetInfoText("$_SLSubmit_FollowerOn")
		EndIf
	ElseIf(option == enableStealOptionID)
		If(!StealActive)
			SetInfoText("$_SLSubmit_StealOff")
		Else
			SetInfoText("$_SLSubmit_StealOn")
		EndIf
	ElseIf(option == enableSellOptionID)
		If(!SellStolen)
			SetInfoText("$_SLSubmit_SellOff")
		Else
			SetInfoText("$_SLSubmit_SellOn")
		EndIf
	ElseIf(option == enableVictimOptionID)
		If(!VictimActive)
			SetInfoText("$_SLSubmit_FemaleOff")
		Else
			SetInfoText("$_SLSubmit_FemaleOn")
		EndIf
	ElseIf(option == enableGuardOptionID)
		If(!GuardActive)
			SetInfoText("$_SLSubmit_GuardOff")
		Else
			SetInfoText("$_SLSubmit_GuardOn")
		EndIf
	ElseIf(option == enableHardcoreOptionID)
		If(!HardcoreActive)
			SetInfoText("$_SLSubmit_HardcoreOff")
		Else
			SetInfoText("$_SLSubmit_HardcoreOn")
		EndIf
	ElseIf(option == enableRepeatOptionID)
		If(!RepeatActive)
			SetInfoText("$_SLSubmit_RepeatOff")
		Else
			SetInfoText("$_SLSubmit_RepeatOn")
		EndIf
	ElseIf(option == enableNoDeathOptionID)
		If(!NoDeathActive)
			SetInfoText("$_SLSubmit_NoDeathOff")
		Else
			SetInfoText("$_SLSubmit_NoDeathOn")
		EndIf
	ElseIf(option == enableVampireOptionID)
		If(!VampireActive)
			SetInfoText("$_SLSubmit_VampireOff")
		Else
			SetInfoText("$_SLSubmit_VampireOn")
		EndIf
	ElseIf(option == enableLoggingOptionID)
		If(!LoggingActive)
			SetInfoText("$_SLSubmit_LoggingOff")
		Else
			SetInfoText("$_SLSubmit_LoggingOn")
		EndIf
	EndIf
EndEvent

Event OnOptionSelect(int option)
	If(option == enableModOptionID)
		modActive = !modActive
		SetToggleOptionValue(enableModOptionID, modActive)
		ActivateMod(modActive)
	EndIf
	If(option == enableDebugOptionID)
		debugActive = !debugActive
		SetToggleOptionValue(enableDebugOptionID, debugActive)
	EndIf
	If(option == enableAttackOptionID)
		AttackActive = !AttackActive
		SetToggleOptionValue(enableAttackOptionID, AttackActive)
		ActivateAttack(modActive && AttackActive)
	EndIf
	If(option == enableDisarmOptionID)
		DisarmActive = !DisarmActive
		SetToggleOptionValue(enableDisarmOptionID, DisarmActive)
	EndIf
	If(option == enableGrappleOptionID)
		GrappleActive = !GrappleActive
		SetToggleOptionValue(enableGrappleOptionID, GrappleActive)
	EndIf
	If(option == enableAmbushSexOptionID)
		AmbushSexActive = !AmbushSexActive
		SetToggleOptionValue(enableAmbushSexOptionID, AmbushSexActive)
	EndIf
	If(option == enableDebuffsOptionID)
		DebuffsActive = !DebuffsActive
		SetToggleOptionValue(enableDebuffsOptionID, DebuffsActive)
	EndIf
	If(option == enableLeveledProgOptionID)
		LeveledProgActive = !LeveledProgActive
		SetToggleOptionValue(enableLeveledProgOptionID, LeveledProgActive)
	EndIf
	If(option == enablePunishmentOptionID)
		PunishmentActive = !PunishmentActive
		SetToggleOptionValue(enablePunishmentOptionID, PunishmentActive)
	EndIf
	If(option == enableSpeechOptionID)
		SpeechActive = !SpeechActive
		SetToggleOptionValue(enableSpeechOptionID, SpeechActive)
		ActivateSpeech(modActive && SpeechActive)
	EndIf
	If(option == enableRobOptionID)
		RobActive = !RobActive
		SetToggleOptionValue(enableRobOptionID, RobActive)
	EndIf
	If(option == enableRapeOptionID)
		RapeActive = !RapeActive
		SetToggleOptionValue(enableRapeOptionID, RapeActive)
		ActivateRape(modActive && RapeActive)
	EndIf
	If(option == enableBondageOptionID)
		BondageActive = !BondageActive
		SetToggleOptionValue(enableBondageOptionID, BondageActive)
	EndIf
	If(option == enableSurrenderOptionID)
		SurrenderActive = !SurrenderActive
		SetToggleOptionValue(enableSurrenderOptionID, SurrenderActive)
		ActivateSurrender(modActive && SurrenderActive)
	EndIf
	If(option == enableFollowerOptionID)
		FollowerActive = !FollowerActive
		SetToggleOptionValue(enableFollowerOptionID, FollowerActive)
	EndIf
	If(option == enableAutoSurrenderOptionID)
		AutoSurrenderActive = !AutoSurrenderActive
		SetToggleOptionValue(enableAutoSurrenderOptionID, AutoSurrenderActive)
		ActivateAutoSurrender(modActive && SurrenderActive && AutoSurrenderActive && !_SLQuest.DeathAlternative)
	EndIf
	If(option == enableStealOptionID)
		StealActive = !StealActive
		SetToggleOptionValue(enableStealOptionID, StealActive)
		ActivateSteal(modActive && SurrenderActive && StealActive)
	EndIf
	If(option == enableSellOptionID)
		SellStolen = !SellStolen
		SetToggleOptionValue(enableSellOptionID, SellStolen)
	EndIf
	If(option == enableVictimOptionID)
		VictimActive = !VictimActive
		SetToggleOptionValue(enableVictimOptionID, VictimActive)
	EndIf
	If(option == enableGuardOptionID)
		GuardActive = !GuardActive
		SetToggleOptionValue(enableGuardOptionID, GuardActive)
	EndIf
	If(option == enableHardcoreOptionID)
		HardcoreActive = !HardcoreActive
		SetToggleOptionValue(enableHardcoreOptionID, HardcoreActive)
	EndIf
	If(option == enableRepeatOptionID)
		RepeatActive = !RepeatActive
		SetToggleOptionValue(enableRepeatOptionID, RepeatActive)
	EndIf
	If(option == enableNoDeathOptionID)
		NoDeathActive = !NoDeathActive
		SetToggleOptionValue(enableNoDeathOptionID, NoDeathActive)
		ActivateNoDeath(modActive && SurrenderActive && AutoSurrenderActive && NoDeathActive)
	EndIf
	If(option == enableVampireOptionID)
		VampireActive = !VampireActive
		SetToggleOptionValue(enableVampireOptionID, VampireActive)
	EndIf
	If(option == enableLoggingOptionID)
		LoggingActive = !LoggingActive
		SetToggleOptionValue(enableLoggingOptionID, LoggingActive)
	EndIf
EndEvent

Event OnOptionSliderOpen(int option)
	If option == oidCooldown
		SetSliderDialogStartValue(ShoutCooldown)
		SetSliderDialogDefaultValue(10.0)
		SetSliderDialogRange(5.0, 15.0)
		SetSliderDialogInterval(1.0)
	ElseIf option == oidCDifficulty
		SetSliderDialogStartValue(CDifficulty)
		SetSliderDialogDefaultValue(0.0)
		SetSliderDialogRange(-25.0, 25.0)
		SetSliderDialogInterval(1.0)
	ElseIf option == oidSDifficulty
		SetSliderDialogStartValue(SDifficulty)
		SetSliderDialogDefaultValue(0.0)
		SetSliderDialogRange(-25.0, 25.0)
		SetSliderDialogInterval(1.0)
	ElseIf option == oidMorality
		SetSliderDialogStartValue(Morality)
		SetSliderDialogDefaultValue(0.0)
		SetSliderDialogRange(0.0, 3.0)
		SetSliderDialogInterval(1.0)
	ElseIf option == oidAutoSubmit
		SetSliderDialogStartValue(AutoSubmitPercent)
		SetSliderDialogDefaultValue(0.0)
		SetSliderDialogRange(0.0, 100.0)
		SetSliderDialogInterval(1.0)
	ElseIf option == oidAutoSubmitChance
		SetSliderDialogStartValue(AutoSubmitChancePercent)
		SetSliderDialogDefaultValue(100.0)
		SetSliderDialogRange(0.0, 100.0)
		SetSliderDialogInterval(1.0)
	ElseIf option == oidBribery
		SetSliderDialogStartValue(Bribery)
		SetSliderDialogDefaultValue(1.0)
		SetSliderDialogRange(1.0, 10.0)
		SetSliderDialogInterval(1.0)
	ElseIf option == oidEscape
		SetSliderDialogStartValue(Escape)
		SetSliderDialogDefaultValue(1.0)
		SetSliderDialogRange(1.0, 5.0)
		SetSliderDialogInterval(1.0)
	ElseIf option == oidCreature
		SetSliderDialogStartValue(Creature)
		SetSliderDialogDefaultValue(0.0)
		SetSliderDialogRange(0.0, 2.0)
		SetSliderDialogInterval(1.0)
	ElseIf option == oidGender
		SetSliderDialogStartValue(Gender)
		SetSliderDialogDefaultValue(0.0)
		SetSliderDialogRange(0.0, 2.0)
		SetSliderDialogInterval(1.0)
	ElseIf option == oidRepeatRate
		SetSliderDialogStartValue(RepeatRate)
		SetSliderDialogDefaultValue(15.0)
		SetSliderDialogRange(5.0, 15.0)
		SetSliderDialogInterval(5.0)
	ElseIf option == oidRange
		SetSliderDialogStartValue(Range)
		SetSliderDialogDefaultValue(500.0)
		SetSliderDialogRange(25.0, 2000.0)
		SetSliderDialogInterval(25.0)
	EndIf
EndEvent

Event OnOptionSliderAccept(int option, float value)
	If option == oidCooldown
		ShoutCooldown = value
		SetSliderOptionValue(oidCooldown, ShoutCooldown, "$_SLSubmit_{0}Seconds")
	ElseIf option == oidCDifficulty
		CDifficulty = value
		SetSliderOptionValue(oidCDifficulty, CDifficulty, "$_SLSubmit_+{0}%CSuccessChance")
	ElseIf option == oidSDifficulty
		SDifficulty = value
		SetSliderOptionValue(oidSDifficulty, SDifficulty, "$_SLSubmit_+{0}%SSuccessChance")
	ElseIf option == oidMorality
		Morality = value
		_SLSubmitFollowerMorality.SetValue(Morality)
		SetSliderOptionValue(oidMorality, Morality, "$_SLSubmit_{0}Morality")
	ElseIf option == oidAutoSubmit
		AutoSubmit = value
		AutoSubmitPercent = value
		SetSliderOptionValue(oidAutoSubmit, AutoSubmitPercent, "$_SLSubmit_{0}AutoSubmit")
		AutoSubmit = AutoSubmitPercent/100
		ActivateAutoSurrenderHit(AutoSubmit > 0)
	ElseIf option == oidAutoSubmitChance
		AutoSubmitChancePercent = value
		SetSliderOptionValue(oidAutoSubmitChance, AutoSubmitChancePercent, "$_SLSubmit_{0}AutoSubmitChance")
		AutoSubmitChance = AutoSubmitChancePercent/100
	ElseIf option == oidBribery
		Bribery = value
		SetSliderOptionValue(oidBribery, Bribery, "$_SLSubmit_{0}Bribery")
	ElseIf option == oidEscape
		Escape = value
		SetSliderOptionValue(oidEscape, Escape, "$_SLSubmit_{0}Escape")
	ElseIf option == oidCreature
		Creature = value
		SetSliderOptionValue(oidCreature, Creature, "$_SLSubmit_{0}Creature")
	ElseIf option == oidGender
		Gender = value
		SetSliderOptionValue(oidGender, Gender, "$_SLSubmit_{0}Gender")
		If (Gender == 0)
			If (PlayerRef.GetActorBase().GetSex() == 0)
				_SLSubmitGenderMaleGlobal.SetValue(0)
				_SLSubmitGenderFemaleGlobal.SetValue(1)
			Else
				_SLSubmitGenderMaleGlobal.SetValue(1)
				_SLSubmitGenderFemaleGlobal.SetValue(0)
			EndIf
		ElseIf (Gender == 1)
			If (PlayerRef.GetActorBase().GetSex() == 0)
				_SLSubmitGenderMaleGlobal.SetValue(1)
				_SLSubmitGenderFemaleGlobal.SetValue(0)
			Else
				_SLSubmitGenderMaleGlobal.SetValue(0)
				_SLSubmitGenderFemaleGlobal.SetValue(1)
			EndIf
		Else
			_SLSubmitGenderMaleGlobal.SetValue(1)
			_SLSubmitGenderFemaleGlobal.SetValue(1)
		EndIf
	ElseIf option == oidRepeatRate
		RepeatRate = value
		SetSliderOptionValue(oidRepeatRate, RepeatRate, "$_SLSubmit_{0}RepeatRate")
	ElseIf option == oidRange
		Range = value
		SetSliderOptionValue(oidRange, Range, "$_SLSubmit_{0}Range")
	EndIf
EndEvent

;============================
; Functions
;============================
int Function GetVersion()
	return 170
EndFunction

Function SetupPages()
	Pages = new string[4]
	Pages[0] = "General"
	pages[1] = "Information"
	Pages[2] = "Player as Victor"
	pages[3] = "Player as Victim"
EndFunction

int Function EnableOption(Bool enableOp=true)
	If enableOp
		return OPTION_FLAG_NONE
	Else
		return OPTION_FLAG_DISABLED
	EndIf
EndFunction

Function ActivateMod(bool activateOrDeactivate)
	ToggleModDependence(EnableOption(activateOrDeactivate))
	
	If activateOrDeactivate
		Debug.Notification("Activating SexLab Submit...")
		_SLQuest.manActivateMod()
	Else
		Debug.Notification("Deactivating SexLab Submit...")
		_SLQuest.manDeactivateMod()
	EndIf
	
	ActivateSpeech(activateOrDeactivate && SpeechActive)
	ActivateRape(activateOrDeactivate && RapeActive)
	ActivateAttack(activateOrDeactivate && AttackActive)
	ActivateSurrender(activateOrDeactivate && SurrenderActive)
	Debug.MessageBox("Please close MCM and reopen it.")
	
	If activateOrDeactivate
		Debug.Notification("SexLab Submit has been activated.")
	Else
		Debug.Notification("SexLab Submit has been deactivated.")
	EndIf
EndFunction

Function ToggleModDependence(int flag)
	SetOptionFlags(keyMapOptionID, flag)
	SetOptionFlags(enableDebugOptionID, flag)
	SetOptionFlags(enableRapeOptionID, flag)
	SetOptionFlags(enableBondageOptionID, flag)
	SetOptionFlags(oidCDifficulty, flag)
	SetOptionFlags(oidMorality, flag)
	SetOptionFlags(enableSpeechOptionID, flag)
	;SetOptionFlags(enableDebuffsOptionID, flag)
	SetOptionFlags(enableLeveledProgOptionID, flag)
	SetOptionFlags(enableLoggingOptionID, flag)
EndFunction

Function ActivateSpeech(bool activateOrDeactivate)
	If activateOrDeactivate
		_SLSubmitDisableSpeechGlobal.SetValue(0)
	Else
		_SLSubmitDisableSpeechGlobal.SetValue(1)
	EndIf
	
	ToggleSpeechDependence(EnableOption(activateOrDeactivate))
EndFunction

Function ToggleSpeechDependence(int flag)
	SetOptionFlags(oidBribery, flag)
	SetOptionFlags(oidSDifficulty, flag)
	SetOptionFlags(oidGender, flag)
	SetOptionFlags(enableGuardOptionID, flag)
EndFunction

Function ActivateRape(bool activateOrDeactivate)
	If(activateOrDeactivate)
		_SLSubmitDisableRapeGlobal.SetValue(0)
	Else
		_SLSubmitDisableRapeGlobal.SetValue(1)
	EndIf
EndFunction

Function ActivateAttack(bool activateOrDeactivate)
	ToggleAttackDependence(EnableOption(activateOrDeactivate))
EndFunction

Function ToggleAttackDependence(int flag)
	SetOptionFlags(oidCooldown, flag)
	SetOptionFlags(enableGrappleOptionID, flag)
	SetOptionFlags(enableAmbushSexOptionID, flag)
	SetOptionFlags(enableRobOptionID, flag)
	SetOptionFlags(enableVictimOptionID, flag)
	SetOptionFlags(enableVampireOptionID, flag)
EndFunction

Function ActivateSurrender(bool activateOrDeactivate)
	ToggleSurrenderDependence(EnableOption(activateOrDeactivate))
	ActivateSteal(activateOrDeactivate && StealActive)
	ActivateAutoSurrender(activateOrDeactivate && AutoSurrenderActive)
EndFunction

Function ToggleSurrenderDependence(int flag)
	SetOptionFlags(oidRange, flag)
	SetOptionFlags(enableStealOptionID, flag)
	SetOptionFlags(oidCreature, flag)
	SetOptionFlags(oidEscape, flag)
	SetOptionFlags(enablePunishmentOptionID, flag)
	SetOptionFlags(enableRepeatOptionID, flag)
	SetOptionFlags(oidRepeatRate, flag)
	SetOptionFlags(enableHardcoreOptionID, flag)
	SetOptionFlags(enableAutoSurrenderOptionID, flag)
	SetOptionFlags(enableFollowerOptionID, flag)
EndFunction

Function ActivateSteal(bool activateOrDeactivate)
	ToggleStealDependence(EnableOption(activateOrDeactivate))
EndFunction

Function ToggleStealDependence(int flag)
	SetOptionFlags(enableSellOptionID, flag)
EndFunction

Function ActivateAutoSurrender(bool activateOrDeactivate)
	ToggleAutoSurrenderDependence(EnableOption(activateOrDeactivate))
	If (activateOrDeactivate)
		If (!PlayerRef.HasMagicEffect(_SLAutoSurrender))
			PlayerRef.AddSpell(_SLSubmitAutoSurrender,false)
		EndIf
	Else
		If (PlayerRef.HasMagicEffect(_SLAutoSurrender))
			PlayerRef.RemoveSpell(_SLSubmitAutoSurrender)
		EndIf
	EndIf
	ActivateAutoSurrenderHit(activateOrDeactivate && AutoSubmit > 0)
	ActivateNoDeath(activateOrDeactivate && NoDeathActive)
EndFunction

Function ToggleAutoSurrenderDependence(int flag)
	SetOptionFlags(oidAutoSubmit, flag)
	SetOptionFlags(oidAutoSubmitChance, flag)
	SetOptionFlags(enableNoDeathOptionID, flag)
EndFunction

Function ActivateAutoSurrenderHit(bool activateOrDeactivate)
	If (activateOrDeactivate)
		If (!PlayerRef.HasMagicEffect(_SLAutoSurrenderHit))
			PlayerRef.AddSpell(_SLSubmitAutoSurrenderHit,false)
		EndIf
	Else
		If (PlayerRef.HasMagicEffect(_SLAutoSurrenderHit))
			PlayerRef.RemoveSpell(_SLSubmitAutoSurrenderHit)
		EndIf
	EndIf
EndFunction

Function ActivateNoDeath(bool activateOrDeactivate)
	If (activateOrDeactivate)
		If (PlayerRef.HasMagicEffect(_SLAutoSurrender) && !PlayerRef.GetActorBase().IsProtected())
			PlayerRef.GetActorBase().SetProtected()
		EndIf
	Else
		If (PlayerRef.GetActorBase().IsProtected())
			PlayerRef.GetActorBase().SetProtected(False)
		EndIf
	EndIf
EndFunction
